    <div class="viewReleases-main-sec">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Track Title</th>
                    <th>Artist</th>
                    <th>Upload Track</th>
            </thead>
            <tbody>

                @foreach ($tracks as $track)
                <tr>
                    <td class="track-title"><span>{{ $track->title ?? '' }}</span></td>
                    <td>
                        @php
                        $artist = getArtistById($track->artists);
                        $artistName = null;
                        if(!empty($artist)) {
                        $artistName = $artist->name;
                        }
                        @endphp

                        {{ $artistName }}
                    </td>

                    <td class="audio-btn-td">
                        @php
                        $trackFiles = [];
                        if(!empty($track->audio_files)){
                        $trackFiles = json_decode($track->audio_files);
                        }
                        @endphp
                        @foreach($trackFiles as $trackFile)
                        @if(!empty($trackFile))
                        <audio controls class="mt-1">
                            <source src="{{ asset(Illuminate\Support\Facades\Storage::url($trackFile)) }}" type="audio/ogg">
                            <source src="{{ asset(Illuminate\Support\Facades\Storage::url($trackFile)) }}" type="audio/mpeg">
                            Your browser does not support the audio element.
                        </audio>
                        @endif
                        @endforeach

                    </td>
                    <td class="add-track-button">
                        <button data-track="{{ $track->id }}" data-release="{{ $release->id }}" class="btn edit" id="editAlbumReleaseTrack">Edit</button>

                        <form method="POST" action="{{ route('release.track.delete') }}" style="display:inline">
                            @csrf
                            <input type="hidden" name="track_id" value="{{ $track->id }}">
                            <input type="hidden" name="release_id" value="{{ $release->id }}">

                            <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn delete">
                                <i class="fa-solid fa-trash"></i> Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
        {!! $tracks->links('pagination::bootstrap-5') !!}
    </div>

    <div class="modal fade add-single-track" id="editReleaseTrackModals" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Update Track</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"><i class="fa-solid fa-xmark"></i></button>
            </div>

            <div id="editTrackModalsData">
            </div>




        </div>
    </div>
</div>

    <script>
        $(document).on('click', '#editAlbumReleaseTrack', function() {
            var track_id = $(this).data('track');
            var release_id = $(this).data('release');

            $.ajax({
                url: "{{ route('release.track.edit') }}",
                type: "POST",
                data: {
                    'track_id': track_id,
                    'release_id': release_id,
                    "_token": "{{ csrf_token() }}"
                },
                cache: false,
                success: function(response) {
                    if (response.error) {
                    alert(response.error);
                    } else {
                        $('#editTrackModalsData').html(response.html);
                        $('#editReleaseTrackModals').modal('show');
                    }
                },
                error: function(textStatus, errorThrown) {
                    alert('Something went wrong!');
                }
            });

        });
    </script>



































    {{--
<div class="col-xs-12 col-sm-12 col-md-12">
        <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#staticBackdrop">
            <button class="btn btn-success" type="button">Add New Track</button>
        </a>


    </div>
    &nbsp;&nbsp;

    <table class="table table-bordered">
    <tr>
       <th>Track Title</th>
       <th>Artist</th>
       <th>Upload Multiple Tracks</th>
       <th width="280px">Action</th>
   </tr>

   @foreach ($tracks as $track)
    <tr>
        <td>{{ $track->title }}</td>
    <td>{{ $track->artists }}</td>
    <td>
        @php
        $trackFiles = [];
        if(!empty($track->audio_files)){
        $trackFiles = json_decode($track->audio_files);
        }
        @endphp
        @foreach($trackFiles as $trackFile)
        @if(!empty($trackFile))
        <audio controls>
            <source src="{{ asset(Illuminate\Support\Facades\Storage::url($trackFile)) }}" type="audio/ogg">
            <source src="{{ asset(Illuminate\Support\Facades\Storage::url($trackFile)) }}" type="audio/mpeg">
            Your browser does not support the audio element.
        </audio>
        @endif

        @endforeach

    </td>
    <td>
        <a class="btn btn-primary btn-sm" href="javascript:void(0);"><i class="fa-solid fa-pen-to-square"></i> Edit</a>
        <form method="POST" action="javascript:void(0);" style="display:inline">
            @csrf
            @method('DELETE')
            <button onclick="return confirm('Are you sure you want to delete?');" type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i> Delete</button>
        </form>
    </td>
    </tr>
    @endforeach
    </table>
    {!! $tracks->links('pagination::bootstrap-5') !!}

    --}}